# Configuration Sync Documentation Index

## 📖 Available Guides

### For Quick Understanding
**[SYNC_QUICK_REFERENCE.md](SYNC_QUICK_REFERENCE.md)** ⭐ **START HERE**
- One-page overview of what to copy
- Critical vs optional items
- Step-by-step sync commands
- Verification checklist
- **Read this if you want to sync RIGHT NOW**

### For Visual Learners
**[SYNC_ARCHITECTURE.md](SYNC_ARCHITECTURE.md)**
- Flow diagrams showing data movement
- Before/after comparison
- Database structure visualization
- Timeline and estimates
- Decision trees for troubleshooting
- **Read this if you like diagrams and flowcharts**

### For Complete Understanding
**[LOCAL_TO_LIVE_SYNC_GUIDE.md](LOCAL_TO_LIVE_SYNC_GUIDE.md)**
- Comprehensive guide with all options
- Database table explanations
- File folder descriptions
- Three different sync strategies
- Common issues and solutions
- **Read this for full details on everything**

---

## 🎯 What Needs to Sync

### Database (SQL)
**Location**: Your MySQL database  
**Tables to export**:
- `business_settings` - All admin configurations
- `banners` - Homepage banners
- `brands` - Product brands  
- `categories` - Product categories
- `shop_settings` - Shop customizations

**Export command**:
```bash
mysqldump -u root -p multivendor \
  business_settings banners brands categories > config.sql
```

### Files (Images & Uploads)
**Location**: `public/storage/`  
**Folders to copy**:
```
public/storage/
├── company/        ← Logos, favicon
├── banner/         ← Homepage banners
├── brand/          ← Brand logos
├── category/       ← Category icons
├── product/        ← Product images
├── shop/           ← Vendor logos
└── profile/        ← User avatars
```

**Copy command**:
```bash
tar -czf storage.tar.gz public/storage/
scp storage.tar.gz username@yourdomain.com:/tmp/
```

---

## ⚡ Quick Start (5 Minutes)

### Step 1: Export from Local
```bash
# Export database
mysqldump -u root -p multivendor \
  business_settings banners brands categories > config.sql

# Compress files
tar -czf storage.tar.gz public/storage/

# Upload both
scp config.sql storage.tar.gz username@yourdomain.com:/tmp/
```

### Step 2: Import on Live (SSH)
```bash
# Login to server
ssh username@yourdomain.com

# Navigate to app
cd /home/username/public_html

# Import database
mysql -u live_user -p'password' live_db < /tmp/config.sql

# Extract files
tar -xzf /tmp/storage.tar.gz

# Fix permissions
chmod -R 755 public/storage/

# Clear cache
php artisan cache:clear
php artisan config:cache

# Verify
curl https://yourdomain.com
```

### Step 3: Verify It Worked
- Open `https://yourdomain.com` in browser
- Should see: logo, banners, correct colors, company name
- Check logs: `tail storage/logs/laravel.log` (no errors)

**Total time**: ~10-30 minutes (depending on file size and connection)

---

## 📚 Reference Tables

### What Each Table Contains

| Table | Contains | Example | Size |
|-------|----------|---------|------|
| `business_settings` | All configurations | company_name, logo path, colors | ~100KB |
| `banners` | Banner records | Banner image paths, positions | ~50KB |
| `brands` | Brand data | Brand names, logos | ~100KB |
| `categories` | Product categories | Category names, icons | ~50KB |
| `shop_settings` | Shop configs | Per-vendor settings | ~20KB |

### What Each Folder Contains

| Folder | Contains | Size | Critical? |
|--------|----------|------|-----------|
| `company/` | Logos, favicon | ~2MB | ✅ YES |
| `banner/` | Banner images | ~15MB | ✅ YES |
| `product/` | Product images | ~200MB+ | ✅ YES |
| `shop/` | Vendor logos | ~20MB | ✅ YES |
| `brand/` | Brand logos | ~5MB | ⚠️ Medium |
| `category/` | Category icons | ~5MB | ⚠️ Medium |
| `profile/` | User avatars | ~50MB | ⭕ Low |

---

## 🔧 Three Sync Options

### OPTION A: Full Sync (Safest for Fresh Setup)
**Use when**: Setting up live server for first time  
**What**: Copy database + all files  
**Time**: ~15 minutes  
**Code**: See SYNC_QUICK_REFERENCE.md

```bash
# Export all
mysqldump -u root -p multivendor > full_backup.sql
tar -czf all_storage.tar.gz public/storage/

# Import all
mysql -u live_user -p'password' live_db < full_backup.sql
tar -xzf all_storage.tar.gz
```

### OPTION B: Config Only (Recommended)
**Use when**: Already have live database  
**What**: Copy settings + critical images only  
**Time**: ~10 minutes  
**Code**: See SYNC_QUICK_REFERENCE.md

```bash
# Export settings
mysqldump -u root -p multivendor \
  business_settings banners > config.sql
tar -czf company_banner_storage.tar.gz \
  public/storage/company/ \
  public/storage/banner/

# Import
mysql -u live_user -p'password' live_db < config.sql
tar -xzf company_banner_storage.tar.gz
```

### OPTION C: Branding Only (Fastest)
**Use when**: Just want logos and colors, already have products  
**What**: Copy company settings + logos only  
**Time**: ~5 minutes  
**Code**: See LOCAL_TO_LIVE_SYNC_GUIDE.md

```bash
# Just the important stuff
mysqldump -u root -p multivendor business_settings > config.sql
cp -r public/storage/company /tmp/

# Import
mysql -u live_user -p'password' live_db < config.sql
cp -r /tmp/company public/storage/
```

---

## ✅ Verification Checklist

After syncing, verify everything:

- [ ] Database imported: `mysql ... -e "SELECT COUNT(*) FROM business_settings;"`
- [ ] Files extracted: `ls public/storage/company/`
- [ ] Permissions fixed: `chmod -R 755 public/storage/`
- [ ] Cache cleared: `php artisan cache:clear`
- [ ] Website loads: Visit `https://yourdomain.com`
- [ ] Logo visible: Browser shows company logo
- [ ] Banners show: Homepage displays banners
- [ ] Colors applied: Check theme colors in CSS
- [ ] Company name: In page title and footer
- [ ] No errors: `tail storage/logs/laravel.log`

---

## 🚨 Common Issues

| Problem | Cause | Fix |
|---------|-------|-----|
| Images not showing | Files not extracted | `tar -xzf storage.tar.gz` |
| Logo missing | Missing company folder | Check `public/storage/company/` |
| Settings not applied | Database not imported | `mysql ... < config.sql` |
| Permission denied | Wrong file permissions | `chmod -R 755 public/storage/` |
| Page title wrong | Cache not cleared | `php artisan cache:clear` |
| 500 error | Database query fail | Check `storage/logs/laravel.log` |

---

## 📋 File Size Estimates

```
Typical sizes:
├── Database (~2-50MB depending on data)
├── company/ logos (~2MB)
├── banner/ images (~15MB)
├── product/ images (~100-500MB+)
├── shop/ logos (~20MB)
├── brand/ logos (~5MB)
└── category/ icons (~5MB)

Total: ~150-600MB+ (highly variable)

Compressed with tar -gz: ~50-200MB
```

---

## 📞 Help Resources

### If You're Stuck
1. Check **SYNC_QUICK_REFERENCE.md** - Simple commands
2. Check **SYNC_ARCHITECTURE.md** - Visual diagrams
3. Check **LOCAL_TO_LIVE_SYNC_GUIDE.md** - Detailed info
4. Reread the verification section above
5. Check error logs: `tail storage/logs/laravel.log`

### Common Commands

```bash
# View database tables
mysql -u user -p'password' database -e "SHOW TABLES;"

# Check table row count
mysql -u user -p'password' database -e "SELECT COUNT(*) FROM table_name;"

# View specific data
mysql -u user -p'password' database -e "SELECT * FROM business_settings LIMIT 5;"

# Check file permissions
ls -la public/storage/

# Fix permissions
chmod -R 755 public/storage/

# Clear Laravel cache
php artisan cache:clear
php artisan config:cache
php artisan view:clear
```

---

## 🎓 Understanding the System

### How Settings Work

1. **Admin configures settings** in admin panel
2. **Settings stored in database** (`business_settings` table)
3. **Images uploaded to** `public/storage/` folder
4. **AppServiceProvider.php loads settings** on every page
5. **Settings made available to templates** as `$web_config`
6. **Templates display** logo, colors, company name, etc.

### Why You Need Both

- **Database** = What to display (settings)
- **Files** = Images to display (actual image files)

Without database: Site won't know what colors/name to use  
Without files: Images will 404 error in browser

---

## 🚀 When to Sync Each Component

| Component | When to Sync | Method |
|-----------|--------------|--------|
| Business settings | Setup, config changes | mysqldump |
| Logos & favicon | Setup, branding update | File copy |
| Banners | Setup, seasonal updates | File copy |
| Product images | When adding bulk products | File copy |
| Brand logos | When changing brands | File copy |
| Category icons | When reorganizing categories | File copy |
| User profiles | Not needed initially | Optional |

---

## 📊 Sync Time By Size

```
Small Database (<10MB) + Small Files (<100MB):
→ 10 minutes total

Medium Database (10-50MB) + Medium Files (100-500MB):
→ 20-30 minutes total

Large Database (50-200MB) + Large Files (500MB-2GB):
→ 45-60 minutes total
(Recommendation: Sync only settings, copy files separately)
```

---

## ✨ What's Next

After syncing:

1. **Verify everything looks right** on live site
2. **Test admin panel** - Can you login and change settings?
3. **Test product browsing** - Do products show with images?
4. **Test checkout** - Does payment process work?
5. **Monitor logs** - Watch for errors over next 24 hours
6. **Keep backups** - Save sync files for future reference

---

## 💡 Pro Tips

✅ **DO:**
- Backup live database before syncing
- Test on subdomain first (test.yourdomain.com)
- Use compression for large files (tar -gz)
- Keep local backups of sync files
- Clear cache after importing

❌ **DON'T:**
- Forget to fix file permissions
- Sync production user data to test server
- Leave old backup files on server
- Skip verification steps
- Import database while users are active

---

## 📖 Document Guide

| Document | Best For | Read Time |
|----------|----------|-----------|
| **SYNC_QUICK_REFERENCE.md** | Quick setup | 5 mins |
| **SYNC_ARCHITECTURE.md** | Understanding flow | 10 mins |
| **LOCAL_TO_LIVE_SYNC_GUIDE.md** | Complete details | 20 mins |

**Choose based on your needs:**
- Want to sync NOW? → QUICK_REFERENCE
- Want to understand HOW? → ARCHITECTURE  
- Want ALL the details? → FULL_GUIDE

---

**Ready to sync? Start with [SYNC_QUICK_REFERENCE.md](SYNC_QUICK_REFERENCE.md)** ⭐

